/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.runtime.step.core.wflgroups;

import filenet.vw.api.VWParameter;
import filenet.vw.api.VWParticipant;
import filenet.vw.api.VWSession;
import filenet.vw.api.VWStepElement;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.runtime.step.core.wflgroups.VWWflGroupValue;
import filenet.vw.toolkit.runtime.step.resources.VWResource;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.dialog.VWUsersDialog;
import filenet.vw.toolkit.utils.table.IVWTableOperation;
import filenet.vw.toolkit.utils.table.VWParticipantItem;
import filenet.vw.toolkit.utils.uicontrols.security.IVWParticipantSelectionDialog;
import filenet.vw.toolkit.utils.uicontrols.security.VWFilteredUsersAndGroupsDialog;
import filenet.vw.toolkit.utils.wfdefinition.VWDefaultSessionProxy;
import java.awt.Frame;
import java.util.Vector;
import javax.swing.JOptionPane;
import javax.swing.table.AbstractTableModel;

public class VWWflGroupTableModel
extends AbstractTableModel
implements IVWTableOperation {
    protected static final int NUM_COLUMNS = 2;
    protected static final int COL_PARAMETER = 0;
    protected static final int COL_VALUE = 1;
    private Vector m_rowCache;
    private Frame m_parentFrame = null;
    private VWStepElement m_vwStepElement = null;
    private IVWParticipantSelectionDialog m_participantDialog = null;

    public VWWflGroupTableModel(Frame parentFrame, VWStepElement stepElement) {
        try {
            this.m_parentFrame = parentFrame;
            this.m_vwStepElement = stepElement;
            this.retrieveRowData();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public int getColumnCount() {
        return 2;
    }

    public Class getColumnClass(int nIndex) {
        switch (nIndex) {
            case 0: {
                return VWParameter.class;
            }
            case 1: {
                return VWWflGroupValue.class;
            }
        }
        return null;
    }

    public String getColumnName(int nIndex) {
        switch (nIndex) {
            case 0: {
                return VWResource.s_name;
            }
            case 1: {
                return VWResource.s_participants;
            }
        }
        return null;
    }

    public int getRowCount() {
        return this.m_rowCache.size();
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        return this.getCellElement(rowIndex, columnIndex);
    }

    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        this.setCellElement(aValue, rowIndex, columnIndex);
    }

    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    public void openItem(int nRowIndex) {
        try {
            VWWflGroupValue vwWflGroupValue = (VWWflGroupValue)this.getValueAt(nRowIndex, 1);
            if (vwWflGroupValue == null) {
                return;
            }
            if (this.m_participantDialog == null) {
                VWSession vwSession = VWDefaultSessionProxy.getSession();
                this.m_participantDialog = vwSession.getSecurityDatabaseType() == 1 ? new VWFilteredUsersAndGroupsDialog(this.m_parentFrame, vwSession) : new VWUsersDialog(this.m_parentFrame, vwSession);
            }
            VWParticipantItem[] participantItems = vwWflGroupValue.getVWParameterValues();
            VWParameter vwParameter = vwWflGroupValue.getVWParameter();
            this.m_participantDialog.init(participantItems, vwParameter.getName());
            this.m_participantDialog.setVisible(true);
            if (this.m_participantDialog.getStatus() == 1) {
                VWParticipant[] participants = null;
                participantItems = this.m_participantDialog.getParticipants();
                if (participantItems == null) {
                    VWParticipant newParticipant = new VWParticipant();
                    newParticipant.setParticipantName("");
                    participants = new VWParticipant[]{newParticipant};
                } else {
                    participants = VWDefaultSessionProxy.getParticipantsFromParticipantItems(participantItems, false);
                }
                if (vwParameter.getMode() == 1) {
                    JOptionPane.showMessageDialog(this.m_parentFrame, VWResource.s_youOnlyHaveReadAccessToParameter, VWResource.s_unableToSaveChanges, 1);
                } else {
                    this.m_vwStepElement.setParameterValue(vwParameter.getName(), participants, false);
                    vwWflGroupValue.setVWParameterValues(participantItems);
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        this.fireTableRowsUpdated(nRowIndex, nRowIndex);
    }

    public void refresh() {
        this.retrieveRowData();
    }

    private void retrieveRowData() {
        try {
            this.m_rowCache = new Vector();
            Vector wflGroups = this.getWorkflowGroups();
            if (wflGroups == null || wflGroups.isEmpty()) {
                return;
            }
            for (int i = 0; i < wflGroups.size(); ++i) {
                VWParameter vwParameter = (VWParameter)wflGroups.elementAt(i);
                if (vwParameter == null) continue;
                Object[] rowData = new Object[this.getColumnCount()];
                rowData[0] = vwParameter;
                rowData[1] = new VWWflGroupValue(vwParameter);
                this.m_rowCache.addElement(rowData);
            }
            this.fireTableDataChanged();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private Object getCellElement(int rowIndex, int columnIndex) {
        if (rowIndex > this.getRowCount() - 1) {
            return null;
        }
        if (columnIndex > this.getColumnCount() - 1) {
            return null;
        }
        return ((Object[])this.m_rowCache.elementAt(rowIndex))[columnIndex];
    }

    private void setCellElement(Object aValue, int rowIndex, int columnIndex) {
        if (rowIndex > this.getRowCount() - 1) {
            return;
        }
        if (columnIndex > this.getColumnCount() - 1) {
            return;
        }
        Object[] rowData = (Object[])this.m_rowCache.elementAt(rowIndex);
        if (rowData != null) {
            rowData[columnIndex] = aValue;
        }
    }

    private Vector getWorkflowGroups() {
        try {
            Vector<VWParameter> params = new Vector<VWParameter>();
            if (this.m_vwStepElement != null) {
                VWParameter[] vwParams = this.m_vwStepElement.getParameters(64, 1);
                if (vwParams != null && vwParams.length > 0) {
                    for (int j = 0; j < vwParams.length; ++j) {
                        String groupName = vwParams[j].getName();
                        boolean bInserted = false;
                        for (int i = 0; i < params.size(); ++i) {
                            VWParameter tempParameter = (VWParameter)params.elementAt(i);
                            if (VWStringUtils.compare(groupName, tempParameter.getName()) >= 0) continue;
                            params.insertElementAt(vwParams[j], i);
                            bInserted = true;
                            break;
                        }
                        if (bInserted) continue;
                        params.addElement(vwParams[j]);
                    }
                }
                if ((vwParams = this.m_vwStepElement.getParameters(64, 2)) != null) {
                    for (int i = 0; i < vwParams.length; ++i) {
                        if (VWStringUtils.compare(vwParams[i].getName(), "F_Trackers") != 0) continue;
                        params.insertElementAt(vwParams[i], 0);
                        break;
                    }
                }
            }
            return params;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }
}

